/////////////////////////////////////////////
//      UNITECH Web Toolbar Functions      //
/////////////////////////////////////////////
//These functions will only work with the
//UNITECH Web Toolbar.  They will not cause
//errors, or otherwise change the behavior of
//an assignable unit, if the course is not
//a UNITECH course.

var ie = (navigator.appName == "Microsoft Internet Explorer");
var moreVideoCheckId = null;
var ready = false;

/*
if (IsUnitechCourse())
{
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		self.onerror = parent.Toolbar.handleErrors;
	}
	else
	{
		window.captureEvents(Event.onerror);
		window.onerror = parent.Toolbar.handleErrors;
	}
}
*/
//////////////////////////////////////
//  Toolbar Manipulation Functions  //     
//////////////////////////////////////////////////////////////////
// The functions below can be called by your courseware pages   //
// to manipulate the toolbar.                                   //
//////////////////////////////////////////////////////////////////

// showCourseMap()
//
// Calling this function will show the coursemap.
function showCourseMap()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.showMap2();
		return true;
	}
	else
	{
		return false;
	}
}

// setActionsLocation(loc)
//
// Calling this function will redirect the actions button
// on the toolbar to any page you specify.  When the current page
// is then exited, the actions button will automatically be 
// reset to point to it's default location, which is "actions.html".
// Note:  All relative paths for the parameter "loc" should be
// relative to the root of the module.
function setActionsLocation(loc)
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.setActionsLocation(loc);
		return true;
	}
	else
	{
		return false;
	}
}

// setDefaultActionsLocation(loc)
//
// Calling this function will change the default actions
// button location.
// Note:  All relative paths for the parameter "loc" should be
// relative to the root of the module.
function setDefaultActionsLocation(loc)
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.setDefaultActionsLocation(loc);
		return true;
	}
	else
	{
		return false;
	}
}

// disableVideoButton()
//
// This function will disable the toolbar's video button, leaving
// it disabled until enableVideoButton() is called.  This function
// is called by pop video pages in the onload handler to disable
// the video button when the page is loaded.
//
// This function is most usefull if you only wish to disable
// the video button for the duration of the currently loaded page.
function disableVideoButton()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.disableVideoButton();
		return true;
	}
	else
	{
		return false;
	}
}

// enableVideoButton()
//
// This function will enable the toolbar's video button.  It will
// not make the video active though.  This function is called by
// pop video pages in the onUnload handler to enable the video
// button after the page is finished.
function enableVideoButton()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.enableVideoButton();
		return true;
	}
	else
	{
		return false;
	}
}

// disableActionsButton()
//
// Calling this function will disable the actions button.
// The actions button will not be enabled again until
// enableActionsButton() is called.
function disableActionsButton()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.disableActionsButton();
		return true;
	}
	else
	{
		return false;
	}
}

// enableActionsButton()
//
// Enables the actions button.
function enableActionsButton()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.enableActionsButton();
		return true;
	}
	else
	{
		return false;
	}
}

// disableNav()
//
// Calling this function will cause a prompt to be displayed
// whenever the the user tries to exit the page.  The prompt
// displayed will read, "You are about to leave without having
// viewed all of the material on this page.  Click 'OK' to
// leave, or 'Cancel' to remain on this page."  Calling
// enableNav() will disable this message, and restore normal
// navigation.
//
// This function is useful if you want to make certain that the
// user has completed the page before leaving.
function disableNav()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.disableNav();
		return true;
	}
	else
	{
		return false;
	}
}

// enableNav()
//
// You would call enableNav() in a page where disableNav()
// was previously called.
//
// Typically you would call disableNav() to prevent the user
// from prematurely exiting the page.  You would then call 
// enableNav() after the user has completed the page so he/she
// can navigate out of the page without receiving a warning message.
function enableNav()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.enableNav();
		return true;
	}
	else
	{
		return false;
	}
}

// disableNavigationButtons()
//
// This function will completely disable the toolbar's
// navigational buttons.  This function could be used on a page
// where you didn't want to let the user leave until the page
// was completed.  When the user does complete the page, 
// you must then call enableNavigationButtons(), or the
// courseware will be stuck at the current page indefinitely.
function disableNavigationButtons()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.disableNavigationButtons();
		return true;
	}
	else
	{
		return false;
	}
}

// enableNavigationButtons()
//
// This function will enable the toolbar's
// navigational buttons.
function enableNavigationButtons()
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.enableNavigationButtons();
		return true;
	}
	else
	{
		return false;
	}
}

// addBookmark(section, topic, subtopic, page)
//
// Adds a bookmark.  The parameters are all integers.
// A subtopic parameter of 0 implies a normal topic.  A subtopic
// of 1 or more implies a subtopic (1->a, 2->b, ....)
function addBookmark(section, topic, subtopic, page)
{
	if (addBookmark.arguments.length != 4)
	{
		alert("The function addBookmark(section, topic, subtopic, page) takes 4 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		topic += parent.Toolbar.getSubtopicLetter(subtopic);
		if (!parent.Toolbar.bookmarkExists(section, topic, page))
		{
			parent.Toolbar.addBookmark(section, topic, page);
		}
	}
}

// deleteBookmark(section, topic, subtopic, page)
//
// Deletes a bookmark.  The parameters are all integers.
// A subtopic parameter of 0 implies a normal topic.  A subtopic
// of 1 or more implies a subtopic (1->a, 2->b, ....)
function deleteBookmark(section, topic, subtopic, page)
{
	if (deleteBookmark.arguments.length != 4)
	{
		alert("The function deleteBookmark(section, topic, subtopic, page) takes 4 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		topic += parent.Toolbar.getSubtopicLetter(subtopic);
		if (parent.Toolbar.bookmarkExists(section, topic, page))
		{
			parent.Toolbar.deleteBookmark(section, topic, page);
		}
	}
}

// bookmarkExists(section, topic, subtopic, page)
//
// See if a bookmark exists.  The parameters are all integers.
// A subtopic parameter of 0 implies a normal topic.  A subtopic
// of 1 or more implies a subtopic (1->a, 2->b, ....)
function bookmarkExists(section, topic, subtopic, page)
{
	if (bookmarkExists.arguments.length != 4)
	{
		alert("The function bookmarkExists(section, topic, subtopic, page) takes 4 parameters!");
		return;
	} 
	if (IsUnitechCourse())
	{
		topic += parent.Toolbar.getSubtopicLetter(subtopic);
		return parent.Toolbar.bookmarkExists(section, topic, page);
	}
}

function gotoPage(section, topic, subtopic, page)
{
	if (gotoPage.arguments.length != 4)
	{
		alert("The function gotoPage(section, topic, subtopic, page) takes 4 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.gotoLink(section, topic + getSubtopicLetter(subtopic), page);
	}
}

function getSubtopicLetter(index)
{
	if (IsUnitechCourse())
	{
		return parent.Toolbar.getSubtopicLetter(index)
	}
}

///////////////////////////////////////////
//    Navigation Access State Function   //
//////////////////////////////////////////////////////////////////
// The functions below are used to set or query the             //
// completion state, locked state, or prerequisites             //
// for a page or topic in the courseware module.                //
// If a SCORM complaint LMS is used to launch this              //
// module, the navigation access states, page completion        //
// states and prerequisites will be saved between sessions.     //
//////////////////////////////////////////////////////////////////
// NOTE: The "subtopic" parameter required by the functions     //
// below is an integer representation of the desired            //
// subtopic.  0 represents no subtopic.  1 represents           //
// subtopic a, 2 represents subtopic b ....                     //
//////////////////////////////////////////////////////////////////

// Calling this function will mark the current page completed.
function markThisPageComplete()
{
	if (markThisPageComplete.arguments.length > 0)
	{
		alert("The function markThisPageComplete() takes no parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		markPageComplete(getSection(), getTopic(), getSubtopic(), getPage());
	}
}

// Marks the specified page complete.
function markPageComplete(section, topic, subtopic, page)
{
	if (markPageComplete.arguments.length != 4)
	{
		alert("The function markPageComplete(section, topic, subtopic, page) takes 4 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.markPageComplete(section, topic, subtopic, page);
	}
}

// Marks the current page as incomplete.
function markThisPageIncomplete()
{
	if (markThisPageIncomplete.arguments.length != 0)
	{
		alert("The function markThisPageIncomplete() takes 0 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		markPageIncomplete(getSection(), getTopic(), getSubtopic(), getPage());
	}
}

// Marks the specified page incomplete.
function markPageIncomplete(section, topic, subtopic, page)
{
	if (markPageIncomplete.arguments.length != 4)
	{
		alert("The function markPageIncomplete(section, topic, subtopic, page) takes 4 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.markPageIncomplete(section, topic, subtopic, page);
	}
}

// Returns true if the current page has been marked as complete,
// false otherwise.
function getThisPageState()
{
	if (getThisPageState.arguments.length != 0)
	{
		alert("The function getThisPageState() takes 0 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		return getPageState(getSection(), getTopic(), getSubtopic(), getPage());
	}
}

// Returns true if the specified page has been marked as complete,
// false otherwise.
function getPageState(section, topic, subtopic, page)
{
	if (getPageState.arguments.length != 4)
	{
		alert("The function getPageState(section, topic, subtopic, page) takes 4 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		return parent.Toolbar.getPageState(section, topic, subtopic, page);
	}
}

// Marks the specified topic complete.
function markTopicComplete(section, topic, subtopic)
{
	if (markTopicComplete.arguments.length != 3)
	{
		alert("The function markTopicComplete(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.markTopicComplete(section, topic, subtopic);
	}
}

// Marks the specified topic incomplete.
function markTopicIncomplete(section, topic, subtopic)
{
	if (markTopicIncomplete.arguments.length != 3)
	{
		alert("The function markTopicIncomplete(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.markTopicIncomplete(section, topic, subtopic);
	}
}

// Returns true if the specified topic has been marked as complete,
// false otherwise.
function getTopicState(section, topic, subtopic)
{
	if (getTopicState.arguments.length != 3)
	{
		alert("The function getTopicState() takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		return parent.Toolbar.getTopicState(getSection(), getTopic(), getSubtopic());
	}
}

// Adds a prerequisite to the specified page.
//
// The page to have the prerequisite added to it is specified by
// the parameters targetSection, targetTopic, targetSubtopic and
// targetPage.  The prerequisite is specified by the parameters
// prereqSection, prereqTopic, prereqSubtopic and prereqPage.
// If only three prereq parameters are specified, then it is assumed
// that the prerequisite is a topic - not a page.
function setPagePrerequisite(targetSection, targetTopic, targetSubtopic, targetPage, prereqSection, prereqTopic, prereqSubtopic, prereqPage)
{
	if (setPagePrerequisite.arguments.length < 7 || setPagePrerequisite.arguments.length > 8)
	{
		alert("The function setPagePrerequisite(targetSection, targetTopic, targetSubtopic, targetPage, prereqSection, prereqTopic, prereqSubtopic[, prereqPage]) takes either 7 or 8 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.setPagePrerequisite(targetSection, targetTopic, targetSubtopic, targetPage, prereqSection, prereqTopic, prereqSubtopic, prereqPage);
	}	
}

// Adds a prerequisite to the current page.
//
// The prerequisite is specified by the parameters
// section, topic, subtopic and page.
// If only three prereq parameters are specified, then it is assumed
// that the prerequisite is a topic - not a page.
function setThisPagePrerequisite(section, topic, subtopic, page)
{
	if (setThisPagePrerequisite.arguments.length < 3 || setPagePrerequisite.arguments.length > 4)
	{
		alert("The function setThisPagePrerequisite(section, topic, subtopic[, page]) takes either 3 or 4 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		setPagePrerequisite(getSection(), getTopic(), getSubtopic(), getPage(), section, topic, subtopic, page);
	}
}

// Hides the specified topic.
function hideTopic(section, topic, subtopic)
{
	if (hideTopic.arguments.length != 3)
	{
		alert("The function hideTopic(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.hideTopic(section, topic, subtopic);
	}
}

// Shows the specified topic.
function showTopic(section, topic, subtopic)
{
	if (showTopic.arguments.length != 3)
	{
		alert("The function showTopic(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.showTopic(section, topic, subtopic);
	}
}

// Locks the current page.
function lockThisPage()
{
	if (lockThisPage.arguments.length != 0)
	{
		alert("The function lockThisPage() requires 0 parameters!");
		return;
	}

	if (IsUnitechCourse())
	{
		lockPage(getSection(), getTopic(), getSubtopic(), getPage());
	}
}

// Locks the specified page.
function lockPage(section, topic, subtopic, page)
{
	if (lockPage.arguments.length != 4)
	{
		alert("The function lockPage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	} 

	if (IsUnitechCourse())
	{
		parent.Toolbar.lockPage(section, topic, subtopic, page);
	}
}

// Unlocks the current page.
function unlockThisPage()
{
	if (unlockThisPage.arguments.length != 0)
	{
		alert("The function unlockThisPage() requires 0 parameters!");
		return;
	}

	if (IsUnitechCourse())
	{
		unlockPage(getSection(), getTopic(), getSubtopic(), getPage());
	}
}

// Unlocks the specified page.
function unlockPage(section, topic, subtopic, page)
{
	if (unlockPage.arguments.length != 4)
	{
		alert("The function unlockPage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	}

	if (IsUnitechCourse())
	{
		parent.Toolbar.unlockPage(section, topic, subtopic, page);
	}
}

// Locks the specified topic.
function lockTopic(section, topic, subtopic)
{
	if (lockTopic.arguments.length != 3)
	{
		alert("The function lockTopic(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.lockTopic(section, topic, subtopic);
	}
}

// Unlocks the specified topic.
function unlockTopic(section, topic, subtopic)
{
	if (unlockTopic.arguments.length != 3)
	{
		alert("The function unlockTopic(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.unlockTopic(section, topic, subtopic);
	}
}

// Mark an entire topic and it's pages as complete.
function markEntireTopicComplete(section, topic, subtopic)
{
	if (markEntireTopicComplete.arguments.length != 3)
	{
		alert("The function markEntireTopicComplete(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.markEntireTopicComplete(section, topic, subtopic);
	}
}
 
// Mark an entire topic and it's pages as incomplete.
function markEntireTopicIncomplete(section, topic, subtopic)
{
	if (markEntireTopicIncomplete.arguments.length != 3)
	{
		alert("The function markEntireTopicIncomplete(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	if (IsUnitechCourse())
	{
		parent.Toolbar.markEntireTopicIncomplete(section, topic, subtopic);
	}
}

// Hides the specified page.
function hidePage(section, topic, subtopic, page)
{
	if (hidePage.arguments.length != 4)
	{
		alert("The function hidePage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	} 

	if (IsUnitechCourse())
	{
		parent.Toolbar.hidePage(section, topic, subtopic, page);
	}
}

// Hides the current page.
function hideThisPage()
{
	if (hideThisPage.arguments.length != 0)
	{
		alert("The function hideThisPage() requires 0 parameters!");
		return;
	} 

	if (IsUnitechCourse())
	{
		parent.Toolbar.hidePage(getSection(), getTopic(), getSubtopic(), getPage());
	}
}

// Shows the specified page.
function showPage(section, topic, subtopic, page)
{
	if (showPage.arguments.length != 4)
	{
		alert("The function showPage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	} 

	if (IsUnitechCourse())
	{
		parent.Toolbar.showPage(section, topic, subtopic, page);
	}
}

// Shows the current page.
function showThisPage()
{
	if (showThisPage.arguments.length != 0)
	{
		alert("The function showThisPage() requires 0 parameters!");
		return;
	} 

	if (IsUnitechCourse())
	{
		parent.Toolbar.showPage(getSection(), getTopic(), getSubtopic(), getPage());
	}
}

function lockEntireTopic(section, topic, subtopic)
{
	if (lockEntireTopic.arguments.length != 3)
	{
		alert("The function lockEntireTopic(section, topic, subtopic) requires 3 parameters!");
		return;
	} 
	
	if (IsUnitechCourse())
	{
		parent.Toolbar.lockEntireTopic(section, topic, subtopic);
	}
}

function unlockEntireTopic(section, topic, subtopic)
{
	if (unlockEntireTopic.arguments.length != 3)
	{
		alert("The function unlockEntireTopic(section, topic, subtopic) requires 3 parameters!");
		return;
	} 
	
	if (IsUnitechCourse())
	{
		parent.Toolbar.unlockEntireTopic(section, topic, subtopic);
	}
}

function lockEntireSection(section)
{
	if (lockEntireSection.arguments.length != 1)
	{
		alert("The function lockEntireSection(section) requires 1 parameter!");
		return;
	} 

	if (IsUnitechCourse())
	{
		parent.Toolbar.lockEntireSection(section);
	}
}

function unlockEntireSection(section)
{
	if (unlockEntireSection.arguments.length != 1)
	{
		alert("The function unlockEntireSection(section) requires 1 parameter!");
		return;
	} 
	
	if (IsUnitechCourse())
	{
		parent.Toolbar.unlockEntireSection(section);
	}
}


///////////////////////////////////
//  PageLoaded and PageUnloaded  //
///////////////////////////////////
	
function pageLoaded()
{
	ready = true;
	if (IsUnitechCourse())
	{
		if (needToCheckForMore())
		{
			moreVideoCheckId = setInterval("checkForMore()",500);
		}
		parent.Toolbar.pageLoaded();
		return true;
	}
	else
	{
		return false;
	}
}

function pageUnloaded()
{
	if (IsUnitechCourse())
	{
		clearInterval(moreVideoCheckId);
		parent.Toolbar.pageUnloaded();
		return true;
	}
	else
	{
		return false;
	}
}


////////////////////////
//  Helper Functions  //
////////////////////////

function isAudioPage()
{
	if (G2_getClipRef("AUDIO_CLIP") != null)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function isVideoPage()
{
	if (G2_getClipRef("VIDEO_CLIP") != null)
	{
		return true;
	}
	else
	{
		return false;
	}
}
 
function subtopicChange(subTopic)
{
	if (IsUnitechCourse())
	{
		parent.Toolbar.subtopicChange(parent.Toolbar.topic + "" + subTopic)
	}
}

function getPageName()
{
	if (IsUnitechCourse())
	{
		return parent.Toolbar.getPageName();
	}
	else
	{
		return null;
	}
}

function getSection()
{
	if (IsUnitechCourse())
	{
		return parent.Toolbar.section;
	}
	else
	{
		return null;
	}
}

function getTopic()
{
	if (IsUnitechCourse())
	{
		return parseInt(parent.Toolbar.topic);
	}
	else
	{
		return null;
	}
}

function getSubtopic()
{
	if (IsUnitechCourse())
	{
		if (parent.Toolbar.inSubtopic())
		{
			for (var i=0;i<parent.Toolbar.topic.length;i++)
			{
				if ( parent.Toolbar.topic.charCodeAt(i) > 57)
				{
					return parent.Toolbar.getSubtopic(parent.Toolbar.topic.slice(i,parent.Toolbar.topic.length))+1;
				}
			}
		}
		else
		{
			return 0;
		}
	}
	else
	{
		return null;
	}
}

function getPage()
{
	if (IsUnitechCourse())
	{
		return parent.Toolbar.page;
	}
	else
	{
		return null;
	}
}

function updateStatus()
{
	if (IsUnitechCourse())
	{
		return parent.Toolbar.updateStatus();
	}
	else
	{
		return null;
	}
}

function needToCheckForMore()
{
	if ( (getLayerRef('MoreImage') == null) || (getLayerRef('VideoLayer') == null) )
	{
		return false;
	}
	else
	{
		return true;
	}
}

function checkForMore()
{
	if ( (getLayerVisibility('MoreImage')) && (getLayerVisibility('VideoLayer')) )
	{
		hideLayer('VideoLayer')
	}
	else
	{
		if ( !(getLayerVisibility('MoreImage')) && !(getLayerVisibility('VideoLayer')) )
		{
			showLayer('VideoLayer')
		}
	}
}

function toolbarCritical()
{
	if (!IsUnitechCourse())
	{
		document.location = "../notoolbar.html";
	}
}

function IsUnitechCourse()
{
	if (parent.Toolbar != null && parent.Toolbar.UNITECH_TOOLBAR)
	{
		return true;
	}
	else
	{
		return false;
	}
}


